﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Accounts
{
    public partial class Administration : BaseComponent
    {
        protected class StudentEditCompetencesPanel : AdminPanel
        {
            public StudentEditCompetencesPanel(Administration Component) : base(Component) { }

            private BL.BO.Student _Student = null;
            protected BL.BO.Student Student
            {
                get
                {
                    if (_Student == null)
                    {
                        if (StudentID.HasValue && StudentID > 0)
                        {
                            _Student = Component.BLELearning.Student.Restore(StudentID);
                        }
                        else
                        {
                            _Student = Component.BLELearning.Student.New();
                        }
                    }

                    return _Student;
                }
            }

            private BL.BO.Class _Class = null;
            protected BL.BO.Class Class
            {
                get
                {
                    if (_Class == null)
                    {
                        _Class = Component.BLELearning.Class.Restore(Student);
                    }

                    return _Class;
                }
            }

            private List<BL.BO.View.CompetencePart_Class> _listCompetencePart_Class = null;
            protected List<BL.BO.View.CompetencePart_Class> CompetencePart_ClassList
            {
                get
                {
                    if (_listCompetencePart_Class == null)
                    {
                        BL.BO.CompetencePart_Class.Search _search = new BL.BO.CompetencePart_Class.Search();
                        _search.ClassID = Student.ClassID;
                        _listCompetencePart_Class = Component.BLELearning.CompetencePart.Class.View.Restore(_search);
                    }
                    return _listCompetencePart_Class;
                }
            }
            
            public override void Load()
            {
                if (Student != null && Component.Instructor != null)
                {
                    Component.AppendToXML(Student);
                    Component.AppendToXML(Class);
                    Component.AppendToXML(Component.BLELearning.School.Restore(Class.SchoolID));

                    BL.BO.Student_CompetencePart.Search _search = new BL.BO.Student_CompetencePart.Search();
                    _search.StudentID = Student.ID;
                    List<BL.BO.Student_CompetencePart> _listStudent_CompetencePart = Component.BLELearning.Statistic.Student.CompetencePart.Restore(_search);

                    Component.XML.Element.Start("CompetencePart_ClassList");
                    foreach (BL.BO.View.CompetencePart_Class _loopCompetencePart_Class in CompetencePart_ClassList)
                    {
                        Component.XML.Element.Start("CompetencePart_Class");
                        Component.XML.Element.Attribute("ClassID", _loopCompetencePart_Class.ClassID);
                        Component.XML.Element.Attribute("CompetenceID", _loopCompetencePart_Class.CompetenceID);
                        Component.XML.Element.Attribute("CompetenceName", _loopCompetencePart_Class.CompetenceName);
                        Component.XML.Element.Attribute("CompetencePartID", _loopCompetencePart_Class.CompetencePartID);
                        Component.XML.Element.Attribute("CompetencePartName", _loopCompetencePart_Class.CompetencePartName);
                        Component.XML.Element.Attribute("ID", _loopCompetencePart_Class.ID);
                        Component.XML.Element.Attribute("IsAvailable", _loopCompetencePart_Class.IsAvailable);

                        BL.BO.Student_CompetencePart _loopStudent_CompetencePart = _listStudent_CompetencePart.FirstOrDefault(x => x.CompetenceID == _loopCompetencePart_Class.CompetenceID && x.CompetencePartID == _loopCompetencePart_Class.CompetencePartID);
                        if (_loopStudent_CompetencePart != null)
                        {
                            Component.XML.Element.Attribute("CaseStudyMaxPoints", _loopStudent_CompetencePart.CaseStudyMaxPoints);
                            Component.XML.Element.Attribute("CaseStudyPoints", _loopStudent_CompetencePart.CaseStudyPoints);
                            Component.XML.Element.Attribute("CompetenceMaxPoints", _loopStudent_CompetencePart.CompetenceMaxPoints);
                            Component.XML.Element.Attribute("CompetencePoints", _loopStudent_CompetencePart.CompetencePoints);
                            Component.XML.Element.Attribute("CompetencePointsByWeight", _loopStudent_CompetencePart.CompetencePointsByWeight);
                            Component.XML.Element.Attribute("IsEnded", _loopStudent_CompetencePart.IsEnded);
                            Component.XML.Element.Attribute("IsStarted", _loopStudent_CompetencePart.IsStarted);
                            Component.XML.Element.Attribute("ResetCount", _loopStudent_CompetencePart.ResetCount);
                            Component.XML.Element.Attribute("Salary", _loopStudent_CompetencePart.Salary);
                        }

                        Component.XML.Element.End();
                    }
                    Component.XML.Element.End();
                }
            }

            public override bool Save()
            {
                if (Student != null && Component.Instructor != null)
                {
                    if (Component.MethodResult.Success)
                    {
                        switch (EditMode)
                        {
                            case EditModeType.EditOrInsert:
                                try
                                {
                                    long? _competencepartid = Component.Environment.GetRequestParamLong("competencepartid");
                                    if (_competencepartid.HasValue)
                                    {
                                        Component.MethodResult.Add(Component.BLELearning.Statistic.CompetencePartStatistic.Reset(Student, _competencepartid));
                                    }                                    
                                }
                                catch (Exception _exception)
                                {
                                    Component.MethodResult.Add(_exception);
                                }
                                break;
                            case EditModeType.Remove:
                                break;
                        }
                    }
                }
                return Component.MethodResult.Success;
            }
        }
    }
}